package music;

public class RockSong extends Song {
	
	private int noOfGuitars;

	public RockSong(String title, Author author, int year, String description, int noOfGuitars) {
		super(title, author, year, description);
		this.noOfGuitars = noOfGuitars;
	}

	public RockSong() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public void playSolo(String solo) {
		System.out.println(solo);
	}
	
	@Override
	public void display() {
		super.display();
		System.out.println("No. of guitars: " + noOfGuitars);
	}
	
	@Override
	public String toString() {
		return getTitle() + ", " + getAuthor().getName();
	}

	public int getNoOfGuitars() {
		return noOfGuitars;
	}

	public void setNoOfGuitars(int noOfGuitars) {
		this.noOfGuitars = noOfGuitars;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + noOfGuitars;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		RockSong other = (RockSong) obj;
		if (noOfGuitars != other.noOfGuitars)
			return false;
		return true;
	}

}
